ORCA/M Asm65816 2.1.0

0001 8324              ***          Copyright Apple Computer, Inc. 1985-1989        ***
0002 8324              ***          All Rights Reserved                             ***
0003 8324
0004 8324                       TITLE 'Start sound function call' 
0005 8324                       EJECT 
0006 8324
0007 8324
0008 8324              ********************************************************
0009 8324              *
0010 8324              *                   08 Aug 90   Braz
0011 8324              *
0012 8324              *                   Added code to handle OneOscFlag for FFSetUpSound
0013 8324              *
0014 8324              *                   Added code to prevent overwrite of last of two
0015 8324              *                   oscillators for FFStartPlaying (used in SetUpSound)
0016 8324              *
0017 8324              ********************************************************
0018 8324
0019 8324
0020 8324
0021 8324
0022 8324
0023 8324
0024 8324
0025 8324
0026 8324
0027 8324
0028 8324
0029 8324              ********************************************************
0030 8324              * SetUpSound is the same as StartSound with the exception that it doesn't start the gen.
0031 8324              *
0032 8324              * Start.sound: This routine will start a generator running.  The mode,
0033 8324              *              generator number and parameter block address are passed
0034 8324              *              on the stack.
0035 8324              *
0036 8324              *     Import: sp + B = gen #
0037 8324              *             sp + A = mode
0038 8324              *             sp + 9 = parameter block bank
0039 8324              *             sp + 8 = parameter block addrh
0040 8324              *             sp + 7 = parameter block addrl
0041 8324              *             sp + 6 = rtl address
0042 8324              *             sp + 3 = rtl address
0043 8324              *
0044 8324              ********************************************************
0045 8324
0046 8324              ***                   include 'all.macros'	;removed 17-Sep-90 DAL
0047 8324                       include 'm16.util2' 
0048 8324                       include 'Snd.Equ.aii' 
0049 8324
0050 8324                       import set_gcb 
0051 8324                       import setup_doc_ram 
0052 8324                       import osctable 
0053 8324
0054 8324                       longa on 
0055 8324                       longi on 
0056 8324                       Export SetUpSound 
0057 8324
0058 8324
0059 8324              SetUpSound PROC 
0060 8324
0061 8324 0B                    phd                            ; save direct regester.
0062 8325 08                    php                            ; save status reg
0063 8326 5B                    tcd                            ; get my dp.
0064 8327 D0 06                 bne   @1                       ; if not zero we were started up.
0065 8329
0066 8329 A9 12 08              lda   #NotInitted              ; Sound Tools wasn't started up.
0067 832C 4C DB 86              jmp   error_out                ; quit returning error.
0068 832F
0069 832F 78           @1       sei                            ; no interruptions please
0070 8330 64 FA                 stz   SndFlags                 ; Don't start the generator.
0071 8332 80 11                 bra   DoStartSound             ; Continue as if startsound call.
0072 8334
0073 8334
0074 8334                       Export StartSound 
0075 8334
0076 8334 0B           Startsound phd                          ; save direct register
0077 8335 08                    php                            ; save status reg
0078 8336 5B                    tcd                            ; get my dp.
0079 8337 D0 06                 bne   @1                       ; if not zero we were started up.
0080 8339
0081 8339 A9 12 08              lda   #NotInitted              ; Sound Tools wasn't started up.
0082 833C 82 9C 00              brl   error_out                ; quit returning error.
0083 833F
0084 833F 78           @1       sei                            ; no interruptions please
0085 8340 A9 00 40              lda   #StartGenFlg             ; Set flag to standard FFStartSound call.
0086 8343 85 FA                 sta   SndFlags
0087 8345
0088 8345
0089 8345              DoStartSound                            ; Entry for FFSetUpCall.
0090 8345 20 57 88              jsr   set_gcb                  ; set up gcb
0091 8348 90 03                 bcc   NotFarAway
0092 834A 4C DB 86              jmp   error_out                ; go away with an error
0093 834D
0094 834D DA           NotFarAway phx                          ; save the gcb pointer
0095 834E 20 1F 89              jsr   setup_doc_ram            ; move from system ram to DOC ram
0096 8351 FA                    plx                            ; restore gcb pointer
0097 8352
0098 8352                       LONGA OFF
0099 8352                       LONGI OFF
0100 8352
0101 8352 E2 30                 sep   #$30
0102 8354 DA                    phx                            ; save gcb.index ;
0103 8355 B5 01                 lda   gcb_gen,x                ; get the generator number
0104 8357 29 0F                 and   #$0F
0105 8359 AA                    tax   
0106 835A BF CA 85 02           lda   >osctable,x              ; get oscillator number
0107 835E 18                    clc                            ; point to control registers
0108 835F 69 A0                 adc   #eocr
0109 8361 8F 3E C0 E1           sta   gadrl
0110 8365
0111 8365 AF CA 00 E1           lda   >irq_volume              ; point to DOC with no auto incr.
0112 8369 8F 3C C0 E1           sta   gstatreg                 ;
0113 836D FA                    plx   
0114 836E B5 01                 lda   gcb_gen,x                ; get generator number
0115 8370 29 F0                 and   #$F0                     ; keep channel number
0116 8372 09 0E                 ora   #$0E                     ; SWAP, Irq enable, GO (halt OFF)
0117 8374 24 FB                 bit   SndFlags+1               ; check if OneOscFlg is set.
0118 8376 10 0A                 bpl   @1                       ; both oscillators ($80 = 0ne osc only)
0119 8378
0120 8378 29 FA                 and   #$FA                     ; One-Shot
0121 837A
0122 837A 24 FB                 bit   SndFlags+1               ; another BRAZ attempt to get FFStartPlaying
0123 837C 70 31                 bvs   New2                     ; to set the sound done flag in the control
0124 837E 09 01                 ora   #01                      ; reg. so FFSoundDoneStatus works for a
0125 8380 80 2D                 bra   New2                     ; single oscillator
0126 8382
0127 8382 24 FB        @1       bit   SndFlags+1               ; check to see if we really want to start the gen.
0128 8384 70 29                 bvs   New2                     ; if StartGenFlg set then start it now.
0129 8386
0130 8386
0131 8386              ;from here to New2 is code to halt the gen for setupparm call.
0132 8386              ; it is necessary to switch mode to loop and halt for both osc.
0133 8386
0134 8386 DA                    phx                            ; save gcb index.
0135 8387 29 F1                 and   #$F1                     ; force into loop mode no irq.
0136 8389 09 01                 ora   #01                      ; otherwize make sure the bit is halted.
0137 838B AA                    tax                            ; save for now. X has Ctrl Reg for EVEN
0138 838C
0139 838C AF 3E C0 E1           lda   gadrl                    ; get the address.
0140 8390 A8                    tay                            ; save address for now.
0141 8391
0142 8391 1A                    inc   a                        ; point to odd osc.
0143 8392 8F 3E C0 E1           sta   gadrl                    ; because it needs to be switched out of loop mode.
0144 8396
0145 8396
0146 8396 AF 3D C0 E1           lda   gdatreg                  ; Braz' new code to fix FFStartPlaying bug
0147 839A AF 3D C0 E1           lda   gdatreg
0148 839E C9 03                 cmp   #$03
0149 83A0 F0 06                 beq   SkipOddOsc
0150 83A2 09 0F                 ora   #$0F
0151 83A4 8F 3D C0 E1           sta   gdatreg
0152 83A8
0153 83A8              *        txa                            ; get my control value back
0154 83A8              *        sta   gdatreg                  ; halt loop mode odd osc.
0155 83A8
0156 83A8
0157 83A8 98           SkipOddOsc tya                          ; get value for control reg for even osc.
0158 83A9 8F 3E C0 E1           sta   gadrl                    ; and point to it.
0159 83AD 8A                    txa                            ; get my control value back again.
0160 83AE FA                    plx                            ; restore x.
0161 83AF
0162 83AF 8F 3D C0 E1  New2     sta   gdatreg                  ; write to DOC control reg.
0163 83B3
0164 83B3                       LONGA ON
0165 83B3                       LONGI ON
0166 83B3 C2 30                 rep   #$30
0167 83B5
0168 83B5 B5 01                 lda   gcb_gen,x                ; get the generator number
0169 83B7 29 0F 00              and   #$0F
0170 83BA A8                    tay   
0171 83BB A9 00 00              lda   #$00
0172 83BE 38                    sec   
0173 83BF 2A           shift_bits rol   A                      	; shift the active bit into position
0174 83C0 18                    clc   
0175 83C1 88                    dey   
0176 83C2 10 FB                 bpl   shift_bits
0177 83C4
0178 83C4 0F B2 1D E1           ora   >sram_base+active_oscs   ; mark generator active
0179 83C8 8F B2 1D E1           sta   >sram_base+active_oscs
0180 83CC A2 00 00              ldx   #00
0181 83CF 28           exit_start plp                          ; restore status register
0182 83D0 2B A2 00 00           endc 6 
0183 83DB              ;
0184 83DB              error_out  
0185 83DB AA                    tax                            ; get the error code
0186 83DC 28                    plp                            ; restore status  register
0187 83DD 2B A0 06 00           eout 6                         ; go out with an error
0188 83E5              ;
0189 83E5              ; >>>--- exit start sound --->>>
0190 83E5              ;
0191 83E5              ;
0192 83E5                       endp 
0193 83E5                       end   
